wwVehicleCombat = { 
    description = "VehicleCombat"
}

function VehicleCombat:new()

	
	--Set unmount distance helper for AI (unused)
	TweakDB:SetFlat("VCUnmountingDistance", -1, 'Float')
	
	--Set amount of threat updates where vehicle is static for enemy to get out
	TweakDB:SetFlat("VC.StaticVehicleUnmountLimit", 10, 'Int32') --Improve how this works
	
	--Improve vehicle chase ai
	
	TweakDB:SetFlat("VehicleActions.UnmountVehicleInCombatCondition_inline0.OR", {"VehicleActions.UnmountVehicleInCombatCondition_inline1", "VehicleActions.UnmountVehicleInCombatCondition_inline2", "VehicleActions.CantGetToTarget", "Condition.DriverDead"})

	--If they can't get to player but player is close
	TweakDB:CloneRecord("VehicleActions.CantGetToTarget", "VehicleActions.UnmountVehicleInCombatCondition_inline2")
	TweakDB:SetFlat("VehicleActions.CantGetToTarget.AND", {"Condition.NotIsFollower", "Condition.NotTargetInVehicle", "Condition.NotCalculatePathToTarget", "Condition.TargetBelow25m"})
	
	--If driver is dead, everyone else get out
	TweakDB:CloneRecord("Condition.DriverDead", "Condition.NotDriverInStimVehicle")
	TweakDB:SetFlat("Condition.DriverDead.vehicle", "AIActionTarget.Owner")
	
	--Get back into vehicle if player has_value
	addAbility("Condition.MountVehicleInCombatCondition.AND", "Condition.TargetInVehicle")
	
	--Add player target for vehicle re-entering
	TweakDB:CloneRecord("Condition.VCPlayerTarget", "Condition.CombatTarget")
	TweakDB:SetFlat("Condition.VCPlayerTarget.target", "AIActionTarget.Player")
	addAbility("Condition.MountVehicleInCombatCondition.AND", "Condition.VCPlayerTarget")
	
	--Adjust spawning distances
	TweakDB:SetFlat("VC.InVehicleSpawnMin", 20, 'Float')
	TweakDB:SetFlat("VC.InVehicleSpawnMax", 60, 'Float')
	TweakDB:SetFlat("VC.InVehicleSpawnDiv", 30, 'Float')


	
	
	--Maxtac
	
	--Make new maxtac characters
	
	--Buff HP regen ability they'll have
	TweakDB:SetFlat("Ability.HasPassiveHealthRegeneration_inline2.valuePerSec", 8)
	
	--Create defensive stats and apply
	createConstantStatModifier("MaxtacHP", "Multiplier", "BaseStats.Health", Maxtac_HP)
	createConstantStatModifier("MaxtacDPS", "Multiplier", "BaseStats.DPS", Maxtac_DPS)
	createConstantStatModifier("MaxtacArmor", "Multiplier", "BaseStats.Armor", 1.5)
	createConstantStatModifier("MaxtacKnockdownImmunity", "BaseStats.KnockdownImmunity", 1)
	createConstantStatModifier("MaxtacBlindImmunity", "Additive", "BaseStats.BlindImmunity", 1)

	addAbility("Character.prevention_maxtac_rifle_ma.statModifiers", "MaxtacHP")
	addAbility("Character.prevention_maxtac_rifle_ma.statModifiers", "MaxtacDPS")
	addAbility("Character.prevention_maxtac_rifle_ma.statModifiers", "MaxtacArmor")
	addAbility("Character.prevention_maxtac_rifle_ma.abilities", "Ability.HasPassiveHealthRegeneration")
	addAbility("Character.prevention_maxtac_rifle_ma.abilities", "Ability.CanGuardBreak")
	addAbility("Character.prevention_maxtac_rifle_ma.statModifiers", "MaxtacKnockdownImmunity")
	addAbility("Character.prevention_maxtac_rifle_ma.statModifiers", "MaxtacBlindImmunity")

	addAbility("Character.prevention_maxtac_rifle_wa.statModifiers", "MaxtacHP")
	addAbility("Character.prevention_maxtac_rifle_ma.statModifiers", "MaxtacDPS")
	addAbility("Character.prevention_maxtac_rifle_wa.statModifiers", "MaxtacArmor")
	addAbility("Character.prevention_maxtac_rifle_wa.abilities", "Ability.HasPassiveHealthRegeneration")
	addAbility("Character.prevention_maxtac_rifle_wa.abilities", "Ability.CanGuardBreak")
	addAbility("Character.prevention_maxtac_rifle_wa.statModifiers", "MaxtacKnockdownImmunity")
	addAbility("Character.prevention_maxtac_rifle_ma.statModifiers", "MaxtacBlindImmunity")

	TweakDB:SetFlat("Character.prevention_maxtac_rifle_ma.statModifierGroups", {"Character.NPC_Base_Primary_Stat_ModGroup", "NPCStatPreset.HighChemicalResistance", "NPCStatPreset.HighThermalResistance", "NPCStatPreset.HighElectricResistance"})
	TweakDB:SetFlat("Character.prevention_maxtac_rifle_wa.statModifierGroups", {"Character.NPC_Base_Primary_Stat_ModGroup", "NPCStatPreset.HighChemicalResistance", "NPCStatPreset.HighThermalResistance", "NPCStatPreset.HighElectricResistance"})

	
	--Make them see everything
	TweakDB:SetFlat("Character.prevention_maxtac_rifle_wa.sensePreset", "Senses.Absolute")
	TweakDB:SetFlat("Character.prevention_maxtac_rifle_ma.sensePreset", "Senses.Absolute")

	--Remove default scaling
	TweakDB:SetFlat("Character.prevention_unit_base_inline0.value", 0)
	
	--Give them maxtac tag
	TweakDB:SetFlat("Character.prevention_maxtac_rifle_wa.tags", {"maxtac"})
	TweakDB:SetFlat("Character.prevention_maxtac_rifle_ma.tags", {"maxtac"})
	
	--Let them drop some stuff
	TweakDB:SetFlat("Character.prevention_maxtac_rifle_wa.dropsWeaponOnDeath", true)
	TweakDB:SetFlat("Character.prevention_maxtac_rifle_wa.dropsAmmoOnDeath", true)
	TweakDB:SetFlat("Character.prevention_maxtac_rifle_ma.dropsWeaponOnDeath", true)
	TweakDB:SetFlat("Character.prevention_maxtac_rifle_ma.dropsAmmoOnDeath", true)

	--Base record
	TweakDB:CloneRecord("Character.MaxtacShotgunner", "Character.prevention_maxtac_rifle_ma")
	TweakDB:CloneRecord("Character.MaxtacMantisWa", "Character.prevention_maxtac_rifle_wa")
	TweakDB:CloneRecord("Character.MaxtacMantisMa", "Character.prevention_maxtac_rifle_wa")
	TweakDB:CloneRecord("Character.MaxtacLMG", "Character.prevention_maxtac_rifle_ma")
	TweakDB:CloneRecord("Character.MaxtacSniper", "Character.prevention_maxtac_rifle_ma")
	TweakDB:CloneRecord("Character.MaxtacNetrunner", "Character.netwatch_agent_netrunner3_omaha_elite")

	--Special netrunner case for stats
	addAbility("Character.MaxtacNetrunner.statModifiers", "MaxtacHP")
	addAbility("Character.MaxtacNetrunner.statModifiers", "MaxtacArmor")
	addAbility("Character.MaxtacNetrunner.statModifiers", "MaxtacDPS")
	addAbility("Character.MaxtacNetrunner.abilities", "Ability.HasPassiveHealthRegeneration")
	addAbility("Character.MaxtacNetrunner.abilities", "Ability.CanGuardBreak")
	addAbility("Character.MaxtacNetrunner.statModifiers", "MaxtacKnockdownImmunity")
	addAbility("Character.MaxtacNetrunner.statModifiers", "MaxtacBlindImmunity")

	TweakDB:SetFlat("Character.MaxtacNetrunner.dropsWeaponOnDeath", true)
	TweakDB:SetFlat("Character.MaxtacNetrunner.dropsAmmoOnDeath", true)
	TweakDB:SetFlat("Character.MaxtacNetrunner.sensePreset", "Senses.Absolute")
	TweakDB:SetFlat("Character.MaxtacNetrunner.tags", {"maxtac"})
	TweakDB:SetFlat("Character.MaxtacNetrunner.statModifierGroups", {"Character.NPC_Base_Primary_Stat_ModGroup", "NPCStatPreset.HighChemicalResistance", "NPCStatPreset.HighThermalResistance", "NPCStatPreset.HighElectricResistance"})
	
	--Body types for the big lads
	TweakDB:SetFlat("Character.MaxtacShotgunner.entityTemplatePath", TweakDB:GetFlat("Character.q001_maxtac_mb.entityTemplatePath"))
	TweakDB:SetFlat("Character.MaxtacLMG.entityTemplatePath", TweakDB:GetFlat("Character.q001_maxtac_mb.entityTemplatePath"))

	--Archetypes
	TweakDB:SetFlat("Character.MaxtacMantisWa.archetypeData", "ArchetypeData.FastMeleeT3")
	TweakDB:SetFlat("Character.MaxtacMantisMa.archetypeData", "ArchetypeData.FastMeleeT3")
	TweakDB:SetFlat("Character.MaxtacSniper.archetypeData", "ArchetypeData.FastSniperT3")
	TweakDB:SetFlat("Character.MaxtacLMG.archetypeData", "ArchetypeData.HeavyRangedT3")
	TweakDB:SetFlat("Character.MaxtacNetrunner.archetypeData", "ArchetypeData.NetrunnerT3")
	
	--Names
	Maxtac_Lieutenant = TweakDB:GetFlat("Character.q001_maxtac_fem.displayName")
	Maxtac_Officer = TweakDB:GetFlat("Character.q001_maxtac_mb.displayName")
	
	TweakDB:SetFlat("Character.MaxtacShotgunner.displayName", Maxtac_Lieutenant)
	TweakDB:SetFlat("Character.MaxtacLMG.displayName", Maxtac_Lieutenant)
	TweakDB:SetFlat("Character.MaxtacMantisWa.displayName", Maxtac_Lieutenant)
	TweakDB:SetFlat("Character.MaxtacMantisMa.displayName", Maxtac_Lieutenant)
	TweakDB:SetFlat("Character.MaxtacSniper.displayName", Maxtac_Officer)
	TweakDB:SetFlat("Character.MaxtacNetrunner.displayName", Maxtac_Officer)
	TweakDB:SetFlat("Character.prevention_maxtac_rifle_ma.displayName", Maxtac_Lieutenant)
	TweakDB:SetFlat("Character.prevention_maxtac_rifle_wa.displayName", Maxtac_Lieutenant)
	--Equipment
	TweakDB:SetFlat("Character.MaxtacShotgunner.primaryEquipment", "Character.MaxtacShotgunnerPrimaryEquipmentGroup")
	TweakDB:SetFlat("Character.MaxtacMantisWa.primaryEquipment", "Character.MaxtacMantisPrimaryEquipmentGroup")
	TweakDB:SetFlat("Character.MaxtacMantisMa.primaryEquipment", "Character.MaxtacMantisPrimaryEquipmentGroup")
	TweakDB:SetFlat("Character.MaxtacSniper.primaryEquipment", "Character.MaxtacSniperPrimaryEquipmentGroup")
	TweakDB:SetFlat("Character.MaxtacLMG.primaryEquipment", "Character.MaxtacLMGPrimaryEquipmentGroup")

	TweakDB:CreateRecord("Character.MaxtacShotgunnerPrimaryEquipmentGroup", "gamedataNPCEquipmentGroup_Record")
	TweakDB:CreateRecord("Character.MaxtacSniperPrimaryEquipmentGroup", "gamedataNPCEquipmentGroup_Record")
	TweakDB:CreateRecord("Character.MaxtacMantisPrimaryEquipmentGroup", "gamedataNPCEquipmentGroup_Record")
	TweakDB:CreateRecord("Character.MaxtacLMGPrimaryEquipmentGroup", "gamedataNPCEquipmentGroup_Record")

	TweakDB:SetFlat("Character.MaxtacShotgunnerPrimaryEquipmentGroup.equipmentItems", {"Character.MaxtacShotgunnerPrimaryEquipment"})
	TweakDB:SetFlat("Character.MaxtacSniperPrimaryEquipmentGroup.equipmentItems", {"Character.MaxtacSniperPrimaryEquipment"})
	TweakDB:SetFlat("Character.MaxtacMantisPrimaryEquipmentGroup.equipmentItems", {"Character.MaxtacMantisPrimaryEquipment"})
	TweakDB:SetFlat("Character.MaxtacLMGPrimaryEquipmentGroup.equipmentItems", {"Character.MaxtacLMGPrimaryEquipment"})

	TweakDB:CloneRecord("Character.MaxtacShotgunnerPrimaryEquipment", "Character.ma_corpo_Satara_Dual_Tech_Shotgun_Base_inline1")
	TweakDB:CloneRecord("Character.MaxtacSniperPrimaryEquipment", "Character.ma_corpo_Nekomata_SemiAuto_Tech_Sniper_Base_inline1")
	TweakDB:CloneRecord("Character.MaxtacMantisPrimaryEquipment", "Character.afterlife_rare_fmelee3_mantis_wa_elite_inline1")
	TweakDB:CloneRecord("Character.MaxtacLMGPrimaryEquipment", "Character.shoot_lmg_ma_corpo_inline1")

	--Create our prevention data
	
	--Make our heat 4 squads
	Maxtac_Squad = {"Character.MaxtacNetrunner", "Character.MaxtacShotgunner", "Character.MaxtacMantisWa", "Character.MaxtacMantisMa", "Character.MaxtacLMG", "Character.MaxtacSniper", "Character.prevention_maxtac_rifle_wa", "Character.prevention_maxtac_rifle_ma"}
	Militech_Squad = {"Character.militech_strongarms_hmelee3_fists_mb_elite", "Character.militech_recon_sniper2_achilles_ma_rare", "Character.militech_ranger2_ranged2_ajax_ma", "Character.militech_ranger2_ranged2_omaha_ma", "Character.militech_tech_franged2_omaha_ma_rare", "Character.militech_enforcer3_gunner3_HMG_mb_elite", "Character.militech_enforcer2_shotgun2_tactician_mah_rare", "Character.militech_tech_grenadier2_omaha_ma_rare"}

	--Set up the prevention data for each faction in each district
	
	Arasaka_Recon_List = Maxtac_Squad
	--Arasaka_Heat_1_List = {"Character.arasaka_guard2_ranged1_kenshin_ma", "Character.arasaka_guard2_ranged1_yukimura_wa", "Character.arasaka_guard2_ranged1_yukimura_ma", "Character.arasaka_guard2_ranged1_shingen_ma"}
	Arasaka_Heat_1_List = {"Character.arasaka_agent_fmelee2rare_katana_wa_rare", "Character.arasaka_netrunner_netrunner2_yukimura_ma_rare", "Character.arasaka_soldier2_shotgun2_tactician_mah_rare"}
	Arasaka_Heat_2_List = {"Character.arasaka_agent_fmelee2rare_katana_ma_rare", "Character.arasaka_netrunner_netrunner2_yukimura_wa_rare", "Character.arasaka_sumo_hmelee2_hammer_mb_rare", "Character.arasaka_tank2_gunner2_defender_mb_rare"}
	Arasaka_Heat_3_List = {"Character.arasaka_ninja_fmelee3_mantis_wa_elite", "Character.arasaka_cyborg_fshotgun3_zhuo_ma_elite", "Character.arasaka_sniper_sniper3_nekomata_ma_elite", "Character.arasaka_sniper_sniper3_ashura_ma_elite", "Character.arasaka_ninja_fmelee3_katana_ma_elite", "Character.arasaka_soldier1_ranged3_masamune_mah_rare", "Character.arasaka_terminator_shotgun3_zhuo_mah_elite", "Character.arasaka_cyborg_franged3_shingen_wa_elite"}
	Arasaka_Heat_4_List = Maxtac_Squad
	Arasaka_Fallback_Unit = "Character.arasaka_security1_ranged1_shingen_ma"
	Arasaka_Vehicles = {"Vehicle.v_standard3_chevalier_emperor_police_siren", "Vehicle.v_sportbike1_yaiba_kusanagi_player", "Vehicle.v_standard3_chevalier_emperor_ncu", "Vehicle.v_standard3_chevalier_emperor_ncu", "Vehicle.v_standard3_chevalier_emperor_police_siren"}

	createPreventionData("PreventionData.Arasaka", Arasaka_Recon_List,8,Arasaka_Heat_1_List, 3, Arasaka_Heat_2_List, 4, Arasaka_Heat_3_List, 8, Arasaka_Heat_4_List, 8, Arasaka_Fallback_Unit, Arasaka_Vehicles, 2, 3, 1, 2, 2)

	NCPD_Recon_List = Maxtac_Squad
	--NCPD_Heat_1_List = {"Character.ncpd_constable_melee1_baton_ma", "Character.ncpd_constable_ranged1_lexington_ma", "Character.ncpd_inspector_melee1_baton_ma", "Character.ncpd_inspector_ranged1_lexington_ma"}
	NCPD_Heat_1_List = {"Character.ncpd_police_ranged2_lexington_wa", "Character.ncpd_enforcer_shotgun2_tactician_ma_rare", "Character.ncpd_police_ranged2_copperhead_ma", "Character.ncpd_police_ranged2_lexington_wa"}
	NCPD_Heat_2_List = {"Character.ncpd_police_shotgun3_crusher_mb_elite", "Character.netwatch_agent_netrunner3_omaha_elite",  "Character.ncpd_police_ranged2_saratoga_wa", "Character.ncpd_hwp_gunner2_defender_mb_rare"}
	NCPD_Heat_3_List = {"Character.ncpd_police_shotgun3_crusher_mb_elite", "Character.ncpd_police_ranged2_copperhead_wa", "Character.ncpd_police_ranged2_saratoga_wa", "Character.ncpd_hwp_gunner2_defender_mb_rare", "Character.ncpd_enforcer_shotgun2_tactician_ma_rare", "Character.netwatch_agent_netrunner3_omaha_elite", "Character.ncpd_police_ranged2_copperhead_ma"}
	NCPD_Heat_4_List = Maxtac_Squad
	NCPD_Fallback_Unit = "Character.ncpd_constable_ranged1_lexington_ma"
	NCPD_Vehicles = {"Vehicle.v_standard3_chevalier_emperor_police_siren", "Vehicle.v_standard2_archer_hella_police_siren", "Vehicle.v_standard2_archer_hella_police_siren", "Vehicle.v_standard2_villefort_cortes_police_siren", "Vehicle.v_standard3_chevalier_emperor_police_siren"}
	createPreventionData("PreventionData.NCPD", NCPD_Recon_List, 8, NCPD_Heat_1_List, 4, NCPD_Heat_2_List, 4, NCPD_Heat_3_List, 6, NCPD_Heat_4_List, 8, NCPD_Fallback_Unit, NCPD_Vehicles, 2, 1, 1, 2, 2)
	
	Maelstrom_Recon_List = Maxtac_Squad
	--Maelstrom_Heat_1_List = {"Character.maelstrom_grunt1_melee1_wrench_wa", "Character.maelstrom_grunt1_ranged1_copperhead_wa", "Character.maelstrom_grunt1_ranged1_lexington_wa", "Character.maelstrom_grunt1_melee1_knife_ma"}
	Maelstrom_Heat_1_List = {"Character.maelstrom_fast2_fmelee2_knife_ma_rare", "Character.maelstrom_fast_fmelee2_machete_ma_rare", "Character.maelstrom_grunt2_ranged2_ajax_ma", "Character.maelstrom_grunt2_ranged2_copperhead_ma"}
	Maelstrom_Heat_2_List = {"Character.maelstrom_netrunner_netrunner2_lexington_ma", "Character.maelstrom_grunt2_melee2_hammer_wa", "Character.maelstrom_grunt2_ranged2_ajax_wa", "Character.maelstrom_techie_grenadier2_lexington_ma"}
	Maelstrom_Heat_3_List = {"Character.maelstrom_fast_fmelee3_mantis_wa_elite", "Character.maelstrom_netrunner_netrunner2_lexington_ma", "Character.maelstrom_strong_gunner2_defender_mb_rare", "Character.maelstrom_fast_sniper2_grad_ma"}
	Maelstrom_Heat_4_List = Maxtac_Squad
	Maelstrom_Fallback_Unit = "Character.maelstrom_grunt1_ranged1_lexington_wa"
	Maelstrom_Vehicles = {"Vehicle.v_standard3_chevalier_emperor_police_siren", "Vehicle.v_standard2_thorton_galena_maelstrom", "Vehicle.v_standard2_thorton_galena_maelstrom", "Vehicle.v_standard2_chevalier_thrax_maelstrom", "Vehicle.v_standard3_chevalier_emperor_police_siren"}
	createPreventionData("PreventionData.Maelstrom", Maelstrom_Recon_List,8,Maelstrom_Heat_1_List, 4, Maelstrom_Heat_2_List, 4, Maelstrom_Heat_3_List, 4, Maelstrom_Heat_4_List, 8, Maelstrom_Fallback_Unit, Maelstrom_Vehicles, 2, 1, 1, 1, 2)
	
	SixthStreet_Recon_List = Maxtac_Squad
	--SixthStreet_Heat_1_List = { "Character.sixthstreet_hooligan_melee1_ironpipe_ma", "Character.sixthstreet_hooligan_ranged1_saratoga_wa", "Character.sixthstreet_hooligan_ranged1_nova_ma", "Character.sixthstreet_hooligan_melee1_knife_wa"}
	SixthStreet_Heat_1_List = {"Character.sixthstreet_menace1_fmelee2_baton_wa_rare", "Character.sixthstreet_menace1_shotgun2_igla_ma", "Character.sixthstreet_menace1_shotgun2_tactician_ma", "Character.sixthstreet_patrol2_melee2_baseball_wa"}
	SixthStreet_Heat_2_List = {"Character.sixthstreet_menace1_fshotgun2_tactician_wa_rare",  "Character.sixthstreet_prepers3_grenadier2_nova_ma_rare", "Character.sixthstreet_sniper2_sniper2_sor22_ma_rare", "Character.sixthstreet_veteran3_ranged2_ajax_ma"}
	SixthStreet_Heat_3_List = {"Character.sixthstreet_patrol2_shotgun3_satara_ma_elite", "Character.sixthstreet_prepers3_shotgun3_carnage_ma_rare", "Character.sixthstreet_patrol2_ranged2_ajax_wa", "Character.sixthstreet_sniper2_sniper2_grad_ma_rare"}
	SixthStreet_Heat_4_List = Maxtac_Squad
	SixthStreet_Fallback_Unit = "Character.sixthstreet_hooligan_ranged1_saratoga_wa"
	SixthStreet_Vehicles = {"Vehicle.v_standard3_chevalier_emperor_police_siren", "Vehicle.v_standard3_thorton_mackinaw_sixth_street", "Vehicle.v_standard2_archer_hella_sixth_street", "Vehicle.v_standard2_chevalier_thrax_sixth_street", "Vehicle.v_standard3_chevalier_emperor_police_siren"}
	createPreventionData("PreventionData.SixthStreet", SixthStreet_Recon_List,8,SixthStreet_Heat_1_List, 4, SixthStreet_Heat_2_List, 4, SixthStreet_Heat_3_List, 4, SixthStreet_Heat_4_List, 8, SixthStreet_Fallback_Unit, SixthStreet_Vehicles, 2, 2, 1, 1, 2)
	
	TygerClaws_Recon_List = Maxtac_Squad
	--TygerClaws_Heat_1_List = {"Character.tyger_claws_biker1_ranged1_nue_wa", "Character.tyger_claws_biker1_ranged1_saratoga_ma", "Character.tyger_claws_gangster1_ranged1_copperhead_ma", "Character.tyger_claws_biker1_ranged1_saratoga_ma"}
	TygerClaws_Heat_1_List = {"Character.tyger_claws_biker3_shotgun2_tactician_wa", "Character.tyger_claws_martial_hmelee2_hammer_mb", "Character.tyger_claws_martial_hmelee2_StrongArms_ma","Character.tyger_claws_gangster2_ranged2_shingen_ma"}
	TygerClaws_Heat_2_List = {"Character.tyger_claws_martial_fmelee2_katana_ma_rare", "Character.tyger_claws_gangster2_ranged2_sidewinder_wa", "Character.tyger_claws_gangster2_melee2_fists_ma", "Character.tyger_claws_gangster2_ranged2_sidewinder_wa"}
	TygerClaws_Heat_3_List = {"Character.tyger_claws_kunoichi_fmelee3_katana_wa_elite", "Character.tyger_claws_ozeki_hmelee3_kanabo_mb", "Character.tygerclaw_gangster3_netrunner_nue_wa_rare", "Character.tyger_claws_gangster3_ranged3_sidewinder_ma"}
	TygerClaws_Heat_4_List = Maxtac_Squad
	TygerClaws_Fallback_Unit = "Character.tyger_claws_biker1_ranged1_saratoga_ma"
	TygerClaws_Vehicles = {"Vehicle.v_standard3_chevalier_emperor_police_siren", "Vehicle.v_sportbike1_yaiba_kusanagi_tyger", "Vehicle.v_sportbike2_arch_tyger", "Vehicle.v_sport1_quadra_turbo_tyger_claw", "Vehicle.v_standard3_chevalier_emperor_police_siren"}
	createPreventionData("PreventionData.TygerClaws", TygerClaws_Recon_List,8,TygerClaws_Heat_1_List, 4, TygerClaws_Heat_2_List, 4, TygerClaws_Heat_3_List, 4, TygerClaws_Heat_4_List, 8, TygerClaws_Fallback_Unit, TygerClaws_Vehicles, 2, 4, 4, 2, 2)
	
	Valentinos_Recon_List = Maxtac_Squad
	--Valentinos_Heat_1_List = {"Character.valentinos_grunt1_melee1_knife_ma", "Character.valentinos_grunt1_ranged1_nova_wa", "Character.valentinos_grunt1_ranged1_nue_wa"}
	Valentinos_Heat_1_List = {"Character.valentinos_grunt2_ranged2_nue_wa", "Character.valentinos_grunt2_ranged2_overture_wa", "Character.valentinos_grunt3_fmelee2_machete_ma_rare", "Character.valentinos_grunt2_ranged2_ajax_ma"}
	Valentinos_Heat_2_List = {"Character.valentinos_grunt4_hmelee2_fists_mb_rare", "Character.valentinos_grunt2_ranged2_ajax_wa", "Character.valentinos_strong2_shotgun2_igla_ma_rare", "Character.valentinos_grunt4_hmelee2_knife_mb_rare"}
	Valentinos_Heat_3_List = {"Character.valentinos_elite3_ranged3_dual_ma_elite", "Character.valentinos_shotgun3_shotgun3_testera_ma_elite", "Character.valentinos_sniper_sniper3_grad_wa_elite", "Character.valentinos_machete_hmelee3_machete_mb_elite"}
	Valentinos_Heat_4_List = Maxtac_Squad
	Valentinos_Fallback_Unit = "Character.valentinos_grunt1_ranged1_nue_ma"
	Valentinos_Vehicles = {"Vehicle.v_standard3_chevalier_emperor_police_siren", "Vehicle.v_sportbike2_arch_jackie_player", "Vehicle.v_standard2_chevalier_thrax_valentino", "Vehicle.v_standard3_thorton_mackinaw_valentinos", "Vehicle.v_standard3_chevalier_emperor_police_siren"}
	createPreventionData("PreventionData.Valentinos", Valentinos_Recon_List,8,Valentinos_Heat_1_List, 4, Valentinos_Heat_2_List, 4, Valentinos_Heat_3_List, 4, Valentinos_Heat_4_List, 8, Valentinos_Fallback_Unit, Valentinos_Vehicles, 2, 4, 1, 2, 2)
	
	VoodooBoys_Recon_List = Maxtac_Squad
	--VoodooBoys_Heat_1_List = {"Character.scavenger_grunt1_melee1_tireiron_wa", "Character.scavenger_grunt1_ranged1_nova_ma","Character.scavenger_grunt1_ranged1_nova_wa","Character.scavenger_grunt1_ranged1_pulsar_wa"}
	VoodooBoys_Heat_1_List = {"Character.voodooboys_grunt1_fmelee2rare_baseball_ma_rare", "Character.voodooboys_grunt1_ranged2_saratoga_ma", "Character.voodooboys_grunt1coat_shotgun2_palica_ma", "Character.voodooboys_netrunner2_netrunner2_lexington_ma_rare"}
	VoodooBoys_Heat_2_List = {"Character.scavenger_grunt3_netrunner2_nova_ma_rare","Character.scavenger_strong3_gunner2_defender_mb_rare","Character.scavenger_fast3_fmelee3_machete_wa_elite", "Character.scavenger_elite3_sniper2_grad_ma"}
	VoodooBoys_Heat_3_List = {"Character.voodooboys_grunt1_ranged2_saratoga_wa","Character.voodooboys_grunt1_ranged2_sidewinder_wa", "Character.voodooboys_grunt3coat_shotgun3_zhuo_ma_elite", "Character.voodooboys_netrunner3_netrunner3_quasar_wa_elite"}
	VoodooBoys_Heat_4_List = Maxtac_Squad
	VoodooBoys_Fallback_Unit = "Character.voodooboys_grunt1_ranged2_saratoga_ma"
	VoodooBoys_Vehicles = {"Vehicle.v_standard3_chevalier_emperor_police_siren", "Vehicle.v_standard2_thorton_galena_voodoo_boys","Vehicle.v_011_scavenger_van", "Vehicle.v_standard25_mahir_voodoo_boys", "Vehicle.v_standard3_chevalier_emperor_police_siren"}
	createPreventionData("PreventionData.VoodooBoys", VoodooBoys_Recon_List,8,VoodooBoys_Heat_1_List, 4, VoodooBoys_Heat_2_List, 4, VoodooBoys_Heat_3_List, 4, VoodooBoys_Heat_4_List, 8, VoodooBoys_Fallback_Unit, VoodooBoys_Vehicles, 2, 1, 2, 1, 2)
	
	Wraiths_Recon_List = Militech_Squad
	--Wraiths_Heat_1_List = {"Character.wraiths_grunt1_melee1_ironpipe_ma", "Character.wraiths_grunt1_ranged1_pulsar_wa", "Character.wraiths_grunt1_ranged1_nova_ma", "Character.wraiths_grunt1_ranged1_pulsar_ma"}
	Wraiths_Heat_1_List = {"Character.wraiths_grunt2_melee2_crowbar_wa","Character.wraiths_grunt2_ranged2_copperhead_ma","Character.wraiths_ghost2_sniper2_achilles_ma_rare", "Character.wraiths_grunt2_ranged2_pulsar_wa"}
	Wraiths_Heat_2_List = {"Character.wraiths_operator3_shotgun2_crusher_ma_rare", "Character.wraiths_ghost2_sniper2_achilles_ma_rare","Character.wraiths_grunt2_melee2_crowbar_wa", "Character.wraiths_grunt2_ranged2_pulsar_wa","Character.wraiths_grunt2_melee2_crowbar_ma","Character.wraiths_grunt2_ranged2_copperhead_wa"}
	Wraiths_Heat_3_List = {"Character.wraiths_warrior3_melee3_hammer_wa_rare","Character.wraiths_strong_gunner3_hmg_mb_elite","Character.wraiths_warrior3_ranged3_quasar_wa_rare","Character.wraiths_warrior3_shotgun3_palica_ma_elite", "Character.wraiths_prisoner_fmelee3_fists_ma_elite", "Character.wraiths_warrior3_shotgun3_satara_ma_elite", "Character.wraiths_strongarms_hmelee3_fists_mb_elite", "Character.wraiths_warrior3_ranged3_quasar_wa_rare"}
	Wraiths_Heat_4_List = Militech_Squad
	Wraiths_Fallback_Unit = "Character.wraiths_grunt1_ranged1_pulsar_ma"
	Wraiths_Vehicles = {"Vehicle.v_standard3_chevalier_emperor_militech", "Vehicle.v_standard2_thorton_galena_nomad_wraith", "Vehicle.v_sport2_quadra_type66_nomad_wraith", "Vehicle.v_standard25_thorton_colby_nomad_wraith", "Vehicle.v_standard3_chevalier_emperor_militech"} --v_standard2_thorton_galena_nomad_wraith
	createPreventionData("PreventionData.Wraiths", Wraiths_Recon_List,8,Wraiths_Heat_1_List, 4, Wraiths_Heat_2_List, 6, Wraiths_Heat_3_List, 8, Wraiths_Heat_4_List, 8 * Backup_Enemies_Scalar, Wraiths_Fallback_Unit, Wraiths_Vehicles, 2, 2, 3, 4, 2 * Backup_Enemies_Scalar)

	
	--Assign by district
	
	Arasaka_Districts = {"Districts.ArasakaWarehouse", "Districts.ArasakaWaterfront"}
	Maelstrom_Districts = {"Districts.Northside"}
	SixthStreet_Districts = {"Districts.Arroyo", "Districts.RanchoCoronado"}
	TygerClaws_Districts = {"Districts.Kabuki", "Districts.JapanTown", "Districts.CharterHill", "Districts.LittleChina"}
	Valentinos_Districts = {"Districts.VistaDelRey", "Districts.Glen", "Districts.Wellsprings"}
	VoodooBoys_Districts = {"Districts.Coastview",  "Districts.WestWindEstate", "Districts.GrandImperialMall"}
	Wraiths_Districts = {"Districts.JacksonPlains", "Districts.NorthBadlands","Districts.RedPeaks", "Districts.RattlesnakeCreek", "Districts.RockyRidge", "Districts.SierraSonora", "Districts.RockyRidge", "Districts.SouthBadlands", "Districts.TrailerPark"}

	assignFaction(Arasaka_Districts, "PreventionData.Arasaka")
	assignFaction(Maelstrom_Districts,  "PreventionData.Maelstrom")
	assignFaction(SixthStreet_Districts, "PreventionData.SixthStreet")
	assignFaction(TygerClaws_Districts, "PreventionData.TygerClaws")
	assignFaction(Valentinos_Districts, "PreventionData.Valentinos")
	assignFaction(VoodooBoys_Districts,"PreventionData.VoodooBoys")
	assignFaction(Wraiths_Districts,  "PreventionData.Wraiths")

	--Set some faction markers

	--Watson
	TweakDB:SetFlat("Districts.Watson.gangs", {"Factions.TygerClaws","Factions.Maelstrom", "Factions.TheMox", "Factions.Arasaka"})
	TweakDB:SetFlat("Districts.Kabuki.gangs", {"Factions.TygerClaws", "Factions.TheMox"})
	TweakDB:SetFlat("Districts.LittleChina.gangs", {"Factions.TygerClaws"})
	TweakDB:SetFlat("Districts.ArasakaWaterfront.gangs", {"Factions.Arasaka"})
	TweakDB:SetFlat("Districts.Northside.gangs", {"Factions.Maelstrom"})

	--Westbrook
	TweakDB:SetFlat("Districts.Westbrook.gangs", {"Factions.TygerClaws", "Factions.TheMox", "Factions.NCPD"})
	TweakDB:SetFlat("Districts.JapanTown.gangs", {"Factions.TygerClaws", "Factions.TheMox"})
	TweakDB:SetFlat("Districts.CharterHill.gangs", {"Factions.TygerClaws"})
	TweakDB:SetFlat("Districts.NorthOaks.gangs", {"Factions.NCPD"})

	--Santo Domingo
	TweakDB:SetFlat("Districts.SantoDomingo.gangs", {"Factions.SixthStreet"})
	TweakDB:SetFlat("Districts.Arroyo.gangs", {"Factions.SixthStreet"})
	TweakDB:SetFlat("Districts.RanchoCoronado.gangs", {"Factions.SixthStreet"})

	--Pacifica
	TweakDB:SetFlat("Districts.Pacifica.gangs", {"Factions.VoodooBoys", "Factions.Scavengers"})
	TweakDB:SetFlat("Districts.Coastview.gangs", {"Factions.VoodooBoys", "Factions.Scavengers"})
	TweakDB:SetFlat("Districts.WestWindEstate.gangs", {"Factions.VoodooBoys", "Factions.Scavengers"})

	--Heywood
	TweakDB:SetFlat("Districts.Heywood.gangs", {"Factions.Valentinos"})
	TweakDB:SetFlat("Districts.Wellsprings.gangs", {"Factions.Valentinos"})
	TweakDB:SetFlat("Districts.Glen.gangs", {"Factions.Valentinos"})
	TweakDB:SetFlat("Districts.VistaDelRey.gangs", { "Factions.Valentinos"})
	
	--City Center
	TweakDB:SetFlat("Districts.CityCenter.gangs", {"Factions.NCPD", "Factions.Arasaka", "Factions.Militech"})
	TweakDB:SetFlat("Districts.CorpoPlaza.gangs", {"Factions.NCPD", "Factions.Arasaka", "Factions.Militech"})
	TweakDB:SetFlat("Districts.Downtown.gangs", {"Factions.NCPD"})
	
	--Enable some icons
	TweakDB:SetFlat("Factions.NCPD.iconPath", "logo_ncpd")
	TweakDB:SetFlat("Factions.Scavengers.iconPath", "logo_scavengers")


	
end

function addAbility(list, ability)
	TweakDB:SetFlat("RTDB.ActionTargetPrereq.target", ability)
	abilityhash=TweakDB:GetFlat("RTDB.ActionTargetPrereq.target")
	templist = TweakDB:GetFlat(list)
	if has_value(templist, abilityhash) then
	
	else

		table.insert(templist, ability)
		TweakDB:SetFlat(list, templist)
	end
end
function has_value (tab, val)
    for index, value in ipairs(tab) do
        if value == val then
            return true
        end
    end

    return false
end
function assignFaction(districts, preventionPreset)

	for i,v in ipairs(districts) do

		--Assign the prevention preset
		TweakDB:SetFlat(v..".preventionPreset", preventionPreset)
		
		--Assign faction
		TweakDB:SetFlat(v..".gangs", {faction})
	end
end
function addPreventionTag(character)

	preventionTag = ToCName{ hash_lo = 0x716A056D, hash_hi = 0x5CEA5752 --[[ Prevention --]] }
	triggerpreventionTag = ToCName{ hash_lo = 0x73E8056F, hash_hi = 0x387FFF7C --[[ TriggerPrevention --]] }

	tags = TweakDB:GetFlat(character..".tags")
	if has_value(tags, preventionTag) then
	
	else
		table.insert(tags, "Prevention")
	end
	
	if has_value(tags, triggerpreventionTag) then
	
	else
		--table.insert(tags, "TriggerPrevention")
	end
	
	TweakDB:SetFlat(character..".tags", tags)	

end
function addScaling(character)
	stats = TweakDB:GetFlat(character..".statModifiers")
	scaleID = ToTweakDBID{ hash = 0x865581F5, length = 28 }
	--TweakDB:SetFlat(character..".sensePreset", "Senses.Absolute")
	if has_value(stats, scaleID) then
	
	else
		table.insert(stats, scaleID)
		TweakDB:SetFlat(character..".statModifiers", stats)
	end
	
	addPreventionTag(character)
	addAbility(character..".abilities", "Ability.CanCallReinforcements")

end

function createPreventionData(recordName, recon, reconcount, heat1, heat1count, heat2, heat2count, heat3, heat3count, heat4, heat4count, fallbackunit, vehicles, vehiclesreconcount, vehicles1count, vehicles2count, vehicles3count, vehicles4count)

	--Apply our scalar to count variables
	reconcount = reconcount * Backup_Enemies_Scalar
	heat1count = heat1count *  Backup_Enemies_Scalar
	heat2count = heat2count *  Backup_Enemies_Scalar
	heat3count = heat3count *  Backup_Enemies_Scalar
	heat4count = heat4count *  Maxtac_Scalar
	vehiclesreconcount = vehiclesreconcount *  Backup_Enemies_Scalar
	vehicles1count = vehicles1count *  Backup_Enemies_Scalar
	vehicles2count = vehicles2count *  Backup_Enemies_Scalar
	vehicles3count = vehicles3count * Backup_Enemies_Scalar
	vehicles4count = vehicles4count * Maxtac_Scalar


	--Prevention Data
	
	TweakDB:CloneRecord(recordName, "PreventionData.BountyHunters")
	
	TweakDB:SetFlat(recordName..".deescalationZeroTime", 30)
	TweakDB:SetFlat(recordName..".safeDistance", 300)
	TweakDB:SetFlat(recordName..".spawnOriginMaxDistance", 90)
	TweakDB:SetFlat(recordName..".inputLockTime", Time_Between_Calls)
	
	--What even is a method?
	
	TweakDB:SetFlat(recordName..".recon", recordName.."recon")
	TweakDB:SetFlat(recordName..".heat1", recordName.."heat1")
	TweakDB:SetFlat(recordName..".heat2", recordName.."heat2")
	TweakDB:SetFlat(recordName..".heat3", recordName.."heat3")
	TweakDB:SetFlat(recordName..".heat4", recordName.."heat4")

	--Give em all scaling
	for i,v in ipairs(recon) do
		addScaling(v)
	end	

	for i,v in ipairs(heat1) do
		addScaling(v)
	end	

	for i,v in ipairs(heat2) do
		addScaling(v)
	end	

	for i,v in ipairs(heat3) do
		addScaling(v)
	end	

	for i,v in ipairs(heat4) do
		addScaling(v)
	end	

	addScaling(fallbackunit)

	--Units

	reconunits = {}
	heat1units = {}
	heat2units = {}
	heat3units = {}
	heat4units = {}
	
	for i,v in ipairs(recon) do
		TweakDB:CreateRecord(recordName.."reconunit"..i, "gamedataPreventionUnitPoolData_Record")
		TweakDB:SetFlat(recordName.."reconunit"..i..".characterRecord", v)
		TweakDB:SetFlat(recordName.."reconunit"..i..".weight", 1)
		table.insert(reconunits, recordName.."reconunit"..i)
	end
	for i,v in ipairs(heat1) do
		TweakDB:CreateRecord(recordName.."heat1unit"..i, "gamedataPreventionUnitPoolData_Record")
		TweakDB:SetFlat(recordName.."heat1unit"..i..".characterRecord", v)
		TweakDB:SetFlat(recordName.."heat1unit"..i..".weight", 1)
		table.insert(heat1units, recordName.."heat1unit"..i)
	end
	for i,v in ipairs(heat2) do
		TweakDB:CreateRecord(recordName.."heat2unit"..i, "gamedataPreventionUnitPoolData_Record")
		TweakDB:SetFlat(recordName.."heat2unit"..i..".characterRecord", v)
		TweakDB:SetFlat(recordName.."heat2unit"..i..".weight", 1)
		table.insert(heat2units, recordName.."heat2unit"..i)
	end
	for i,v in ipairs(heat3) do
		TweakDB:CreateRecord(recordName.."heat3unit"..i, "gamedataPreventionUnitPoolData_Record")
		TweakDB:SetFlat(recordName.."heat3unit"..i..".characterRecord", v)
		TweakDB:SetFlat(recordName.."heat3unit"..i..".weight", 1)
		table.insert(heat3units, recordName.."heat3unit"..i)
	end
	for i,v in ipairs(heat4) do
		TweakDB:CreateRecord(recordName.."heat4unit"..i, "gamedataPreventionUnitPoolData_Record")
		TweakDB:SetFlat(recordName.."heat4unit"..i..".characterRecord", v)
		TweakDB:SetFlat(recordName.."heat4unit"..i..".weight", 1)
		table.insert(heat4units, recordName.."heat4unit"..i)
	end
	
	--Fallback unit
	
	TweakDB:CreateRecord(recordName.."fallbackunit", "gamedataPreventionFallbackUnitData_Record")
	TweakDB:SetFlat(recordName.."fallbackunit.characterRecord", fallbackunit)
	TweakDB:SetFlat(recordName.."fallbackunit.minSpawnRange", 35)
	TweakDB:SetFlat(recordName.."fallbackunit.unitsCount", 1)

	--Heat data
	
	Spawn_Range = TweakDB:GetFlat("PreventionData.BorderGuards_inline0.spawnRange")
	
	TweakDB:CloneRecord(recordName.."recon", "PreventionData.BountyHunters_inline0")
	TweakDB:SetFlat(recordName.."recon.unitRecordsPool", reconunits)
	TweakDB:SetFlat(recordName.."recon.unitsCount", reconcount)
	TweakDB:SetFlat(recordName.."recon.fallbackUnitData", recordName.."fallbackunit")
	TweakDB:SetFlat(recordName.."recon.vehicleRecord", vehicles[1])
	TweakDB:SetFlat(recordName.."recon.vehicleCount", vehiclesreconcount, 'Int32')
	TweakDB:SetFlat(recordName.."recon.spawnRange", Spawn_Range)
	TweakDB:SetFlat(recordName.."recon.spawnInterval", 0.1)


	TweakDB:CloneRecord(recordName.."heat1", "PreventionData.BountyHunters_inline9")
	TweakDB:SetFlat(recordName.."heat1.unitRecordsPool", heat1units)
	TweakDB:SetFlat(recordName.."heat1.unitsCount", heat1count)
	TweakDB:SetFlat(recordName.."heat1.fallbackUnitData", recordName.."fallbackunit")
	TweakDB:SetFlat(recordName.."heat1.vehicleRecord", vehicles[2])
	TweakDB:SetFlat(recordName.."heat1.vehicleCount", vehicles1count, 'Int32')
	TweakDB:SetFlat(recordName.."heat1.spawnRange", Spawn_Range)
	TweakDB:SetFlat(recordName.."heat1.spawnInterval", 0.1)

	TweakDB:CloneRecord(recordName.."heat2", "PreventionData.BountyHunters_inline13")
	TweakDB:SetFlat(recordName.."heat2.unitRecordsPool", heat2units)
	TweakDB:SetFlat(recordName.."heat2.unitsCount", heat2count)
	TweakDB:SetFlat(recordName.."heat2.fallbackUnitData", recordName.."fallbackunit")
	TweakDB:SetFlat(recordName.."heat2.vehicleRecord", vehicles[3])
	TweakDB:SetFlat(recordName.."heat2.vehicleCount", vehicles2count, 'Int32')
	TweakDB:SetFlat(recordName.."heat2.spawnRange", Spawn_Range)
	TweakDB:SetFlat(recordName.."heat2.spawnInterval", 0.1)

	TweakDB:CloneRecord(recordName.."heat3", "PreventionData.BountyHunters_inline2")
	TweakDB:SetFlat(recordName.."heat3.unitRecordsPool", heat3units)
	TweakDB:SetFlat(recordName.."heat3.unitsCount", heat3count)
	TweakDB:SetFlat(recordName.."heat3.fallbackUnitData", recordName.."fallbackunit")
	TweakDB:SetFlat(recordName.."heat3.vehicleRecord", vehicles[4])
	TweakDB:SetFlat(recordName.."heat3.vehicleCount", vehicles3count, 'Int32')
	TweakDB:SetFlat(recordName.."heat3.spawnRange", Spawn_Range)
	TweakDB:SetFlat(recordName.."heat3.spawnInterval", 0.1)

	TweakDB:CloneRecord(recordName.."heat4", "PreventionData.BountyHunters_inline19")
	TweakDB:SetFlat(recordName.."heat4.unitRecordsPool", heat4units)
	TweakDB:SetFlat(recordName.."heat4.unitsCount", heat4count)
	TweakDB:SetFlat(recordName.."heat4.fallbackUnitData", recordName.."fallbackunit")
	TweakDB:SetFlat(recordName.."heat4.vehicleRecord", vehicles[5])
	TweakDB:SetFlat(recordName.."heat4.vehicleCount", vehicles4count, 'Int32')
	TweakDB:SetFlat(recordName.."heat4.spawnRange", Spawn_Range)
	TweakDB:SetFlat(recordName.."heat4.spawnInterval", 0.1)

	
end
function createConstantStatModifier(recordName, modifierType, statType, value)
	TweakDB:CreateRecord(recordName, "gamedataConstantStatModifier_Record")
	TweakDB:SetFlat(recordName..".modifierType", modifierType)
	TweakDB:SetFlat(recordName..".statType", statType)
	TweakDB:SetFlat(recordName..".value", value)
end


return VehicleCombat:new()
